#!/usr/bin/env bash
set -e

echo ">> Aguardando Postgres em ${POSTGRES_HOST}:${POSTGRES_PORT}..."
until pg_isready -h "${POSTGRES_HOST}" -p "${POSTGRES_PORT}" -U "${POSTGRES_USER}" >/dev/null 2>&1; do
  sleep 1
done
echo ">> Postgres disponível."

# Migrações
echo ">> Executando migrações..."
python manage.py migrate --noinput

# Criação opcional do superuser (se variáveis estiverem setadas)
if [ -n "$DJANGO_SUPERUSER_USERNAME" ] && [ -n "$DJANGO_SUPERUSER_EMAIL" ] && [ -n "$DJANGO_SUPERUSER_PASSWORD" ]; then
  echo ">> Garantindo superuser..."
  python manage.py shell <<'PYCODE'
import os
from django.contrib.auth import get_user_model
User = get_user_model()
u, created = User.objects.get_or_create(
    username=os.environ["DJANGO_SUPERUSER_USERNAME"],
    defaults={"email": os.environ["DJANGO_SUPERUSER_EMAIL"]}
)
if created:
    u.set_password(os.environ["DJANGO_SUPERUSER_PASSWORD"])
    u.is_superuser = True
    u.is_staff = True
    u.save()
PYCODE
fi

# Coleta de estáticos (opcional; útil se usar admin e servir em prod com nginx)
# python manage.py collectstatic --noinput

# Servidor de aplicação
# Para desenvolvimento (autoreload):
echo ">> Iniciando servidor Django (dev) em 0.0.0.0:${APP_PORT}..."
exec python manage.py runserver 0.0.0.0:${APP_PORT}

# Para produção, troque a última linha por algo como:
# exec gunicorn seu_projeto.wsgi:application --bind 0.0.0.0:${APP_PORT} --workers 3
